/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens;

import java.util.Iterator;
import java.util.function.Consumer;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import me.srrapero720.waterframes.common.screens.styles.ScreenStyles;
import me.srrapero720.waterframes.common.screens.widgets.WidgetTripleTable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiIcon;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;

public class RemoteControlScreen
extends GuiLayer {
    private static final int WIDTH = 60;
    private static final int HEIGHT = 180;
    private static final int BUTTON_SIZE = 12;
    public GuiButtonIcon active;
    public GuiButtonIcon muted;
    public GuiButtonIcon reload;
    public GuiIcon signal;
    public GuiButtonIcon arrowUp;
    public GuiButtonIcon arrowDown;
    public GuiButtonIcon arrowLeft;
    public GuiButtonIcon arrowRight;
    public GuiButtonIcon arrowCenter;
    public GuiButtonIcon play;
    public GuiButtonIcon pause;
    public GuiButtonIcon stop;
    public GuiButtonIcon volumeUp;
    public GuiButtonIcon volumeDown;
    public GuiButtonIcon channelUp;
    public GuiButtonIcon channelDown;
    public GuiButtonIcon rewind;
    public GuiButtonIcon fastfoward;
    private boolean allEnabled = true;
    protected final DisplayTile tile;
    private final class_1657 player;
    private final class_2487 nbt;
    private final class_1792 item;

    public RemoteControlScreen(class_1657 player, DisplayTile tile, class_2487 nbt, class_1792 item) {
        super("remote_screen", 60, 180);
        this.player = player;
        this.nbt = nbt;
        this.item = item;
        this.align = Align.STRETCH;
        this.flow = GuiFlow.STACK_Y;
        this.tile = tile;
        this.signal = new GuiIcon("signal_icon", IconStyles.SIGNAL_4);
        this.active = new GuiButtonIcon(this, "active_toggle", IconStyles.OFF_ON, button -> tile.setActive(true, !tile.data.active)){

            @Environment(value=EnvType.CLIENT)
            public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
                return ScreenStyles.RED_BACKGROUND;
            }

            @Environment(value=EnvType.CLIENT)
            public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
                return ScreenStyles.RED_BORDER;
            }
        };
        this.muted = new GuiButtonIcon(this, "muted_toggle", IconStyles.VOLUME_0, button -> tile.setMute(true, !tile.data.muted)){

            @Environment(value=EnvType.CLIENT)
            public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
                return ScreenStyles.BLUE_BACKGROUND;
            }

            @Environment(value=EnvType.CLIENT)
            public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
                return ScreenStyles.BLUE_BORDER;
            }
        };
        this.arrowUp = new GuiButtonIcon("arrow_up", IconStyles.ARROW_UP, button -> tile.position(true, null, tile.data.getPosY().up()));
        this.arrowDown = new GuiButtonIcon("arrow_down", IconStyles.ARROW_DOWN, button -> tile.position(true, null, tile.data.getPosY().down()));
        this.arrowLeft = new GuiButtonIcon("arrow_left", IconStyles.ARROW_LEFT, button -> tile.position(true, tile.data.getPosX().left(), null));
        this.arrowRight = new GuiButtonIcon("arrow_right", IconStyles.ARROW_RIGHT, button -> tile.position(true, tile.data.getPosX().right(), null));
        this.arrowCenter = new GuiButtonIcon("arrow_center", IconStyles.ARROW_CENTER, button -> tile.position(true, PositionHorizontal.CENTER, PositionVertical.CENTER));
        if (!tile.caps.resizes()) {
            this.arrowUp.setEnabled(false);
            this.arrowDown.setEnabled(false);
            this.arrowLeft.setEnabled(false);
            this.arrowRight.setEnabled(false);
            this.arrowCenter.setEnabled(false);
        }
        this.reload = new GuiButtonIcon("reload", IconStyles.RELOAD, button -> {
            if (tile.imageCache != null) {
                tile.imageCache.reload();
            }
        });
        this.play = new GuiButtonIcon("pause", IconStyles.PAUSE, button -> tile.setPause(true, true));
        this.pause = new GuiButtonIcon("play", IconStyles.PLAY, button -> tile.setPause(true, false));
        this.stop = new GuiButtonIcon("stop", IconStyles.STOP, button -> tile.setStop(true));
        this.volumeUp = new GuiButtonIcon("volume_up", IconStyles.VOLUME_UP, button -> tile.volumeUp(true));
        this.volumeDown = new GuiButtonIcon("volume_down", IconStyles.VOLUME_DOWN, button -> tile.volumeDown(true));
        this.channelUp = new GuiButtonIcon("channel_up", IconStyles.CHANNEL_UP, button -> {});
        this.channelDown = new GuiButtonIcon("channel_down", IconStyles.CHANNEL_DOWN, button -> {});
        this.channelUp.setTooltip("waterframes.common.soon").setEnabled(false);
        this.channelDown.setTooltip("waterframes.common.soon").setEnabled(false);
        this.rewind = new GuiButtonIcon("fast_backward", IconStyles.FAST_BACKWARD, button -> tile.rewind(true));
        this.fastfoward = new GuiButtonIcon("fast_forward", IconStyles.FAST_FOWARD, button -> tile.fastFoward(true));
    }

    public void create() {
        this.add(new WidgetTripleTable((GuiFlow)GuiFlow.STACK_Y).spaceBetween().addLeft(new GuiControl[]{this.active.setDim(12, 12).setSquared(true)}).addCenter(this.signal.setDim(12, 12).setSquared(true).setExpandable()).addRight(new GuiControl[]{this.muted.setDim(12, 12).setSquared(true)}).setAllExpandableX().setFixedX());
        this.add(new GuiParent().setExpandableY());
        this.add((GuiControl)new WidgetTripleTable((GuiFlow)GuiFlow.STACK_Y).spaceBetween().addCenter(new GuiControl[]{this.arrowUp.setDim(12, 12).setSquared(true)}).createRow().addCenter(new GuiParent().setDim(1, 2)).createRow().addLeft(new GuiControl[]{this.arrowLeft.setDim(12, 12).setSquared(true)}).addCenter(new GuiControl[]{this.arrowCenter.setDim(12, 12).setSquared(true)}).addRight(new GuiControl[]{this.arrowRight.setDim(12, 12).setSquared(true)}).createRow().addCenter(new GuiParent().setDim(1, 2)).createRow().addCenter(new GuiControl[]{this.arrowDown.setDim(12, 12).setSquared(true)}));
        this.add(new GuiParent().setExpandableY());
        this.add(new WidgetTripleTable((GuiFlow)GuiFlow.STACK_Y).spaceBetween().addLeft(new GuiControl[]{this.volumeUp.setDim(12, 14).setSquared(true)}).addRight(new GuiControl[]{this.channelUp.setDim(12, 14).setSquared(true)}).setAllExpandableX().createRow().addLeft(new GuiControl[]{this.volumeDown.setDim(12, 14).setSquared(true)}).addCenter(new GuiControl[]{this.reload.setDim(12, 14).setSquared(true)}).addRight(new GuiControl[]{this.channelDown.setDim(12, 14).setSquared(true)}).setAllExpandableX().setFixedX());
        this.add(new GuiParent().setExpandableY());
        this.add(new WidgetTripleTable((GuiFlow)GuiFlow.STACK_Y).spaceBetween().addLeft(new GuiControl[]{this.pause.setDim(12, 12).setSquared(true)}).addCenter(new GuiControl[]{this.play.setDim(12, 12).setSquared(true)}).addRight(new GuiControl[]{this.stop.setDim(12, 12).setSquared(true)}).createRow().addCenter(new GuiParent().setDim(1, 2)).createRow().addLeft(new GuiControl[]{this.rewind.setDim(12, 12).setSquared(true)}).addRight(new GuiControl[]{this.fastfoward.setDim(12, 12).setSquared(true)}).setAllExpandableX().setFixedX());
        this.tick();
    }

    public void tick() {
        super.tick();
        if (this.tile.method_11015()) {
            this.closeTopLayer();
        }
        if (!this.isClient()) {
            return;
        }
        double distance = WaterFrames.getDistance(this.tile, (class_2374)this.player.method_19538());
        if (distance < (double)DisplaysConfig.maxRcDis()) {
            if (!this.allEnabled) {
                this.allEnabled = true;
                RemoteControlScreen.hyperIterate(this.iterator(), c -> {
                    if (!c.name.contains("arrow") && !c.name.contains("channel")) {
                        c.setEnabled(this.allEnabled);
                    }
                });
            }
            if (distance == 0.0) {
                this.signal.setIcon(IconStyles.SIGNAL_4);
            } else {
                int diff = (int)(distance / (double)DisplaysConfig.maxRcDis() * 100.0);
                if (diff < 25) {
                    this.signal.setIcon(IconStyles.SIGNAL_4);
                } else if (diff < 50) {
                    this.signal.setIcon(IconStyles.SIGNAL_3);
                } else if (diff < 75) {
                    this.signal.setIcon(IconStyles.SIGNAL_2);
                } else if (diff < 100) {
                    this.signal.setIcon(IconStyles.SIGNAL_1);
                }
            }
        } else {
            this.signal.setIcon(IconStyles.SIGNAL_0);
            if (this.allEnabled) {
                this.allEnabled = false;
                RemoteControlScreen.hyperIterate(this.iterator(), c -> {
                    if (c.getClass() != GuiIcon.class) {
                        c.setEnabled(this.allEnabled);
                    }
                });
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public GuiStyle getStyle() {
        return ScreenStyles.REMOTE_CONTROL;
    }

    @Environment(value=EnvType.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BACKGROUND;
    }

    @Environment(value=EnvType.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return ScreenStyles.SCREEN_BORDER;
    }

    public static void hyperIterate(Iterator<GuiChildControl> iterator, Consumer<GuiControl> consumer) {
        while (iterator.hasNext()) {
            GuiControl item = iterator.next().control;
            if (item instanceof GuiParent) {
                GuiParent parent = (GuiParent)item;
                RemoteControlScreen.hyperIterate(parent.iterator(), consumer);
                continue;
            }
            consumer.accept(item);
        }
    }
}

